/*
 * Decompiled with CFR 0.152.
 */
package panther.xp;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.JApplet;
import org.w3c.dom.Node;
import panther.util.crypto.ObfuscateDecode;
import panther.util.general.Constants;
import panther.util.general.ErrorUtils;
import panther.util.general.StringUtils;
import panther.util.general.XMLUtils;
import panther.util.net.MimeContent;
import panther.util.unicon.Base64Encode;
import panther.xp.PantherAssessmentState;
import panther.xp.XPassUnavailableException;
import panther.xp.XPassUtils;
import pse.pt.PacketTracer;
import pse.util.general.ApplicationError;
import pse.util.general.ThreadUtils;
import pse.util.general.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPassPtsi {
    protected JApplet applet;
    protected String authorizationString;
    protected String myId;
    protected String serverHostAndPort;
    protected String serverHostPortAndTomcatContext;
    protected String tomcatContext;
    protected boolean inAutoSave = false;
    protected boolean inFinalSave = false;
    protected boolean isUp = true;
    protected boolean useCompression;
    protected boolean useConnectivityTestEvaluation;
    protected boolean useEncryption;
    protected String mode;
    protected String sessionId;
    protected String erId;
    protected String requestingHost;
    protected int generation = 0;
    protected int maximumSessionPieceSize = 50000;
    protected long lastSuccessfulAccess = -1L;
    protected long lastUnsuccessfulAccess = -1L;
    protected String userAgentString = "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.2.13) Gecko/20101203 Firefox/3.6.13 (.NET CLR 3.5.30729)";
    protected String refererString;

    public XPassPtsi(String string) {
        this.myId = string;
    }

    public boolean checkHttpd() {
        try {
            URL uRL = new URL("http://" + this.serverHostAndPort + "/success.html");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("referer", this.refererString);
            httpURLConnection.setRequestProperty("user-agent", this.userAgentString);
            this.addAuthorization(httpURLConnection);
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            skeletonapplet.Utilities.logPrintln("access to success.html ... responseCode = " + n);
            return n == 200;
        }
        catch (Throwable throwable) {
            skeletonapplet.Utilities.logPrintln("access to success.html ... t = " + throwable);
            Utilities.check(throwable);
            return false;
        }
    }

    public boolean checkTomcat() {
        try {
            URL uRL = new URL("http://" + this.serverHostPortAndTomcatContext + "/Success");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            this.addAuthorization(httpURLConnection);
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            skeletonapplet.Utilities.logPrintln("access to Success ... responseCode = " + n);
            return n == 200;
        }
        catch (Throwable throwable) {
            skeletonapplet.Utilities.logPrintln("access to Success ... t = " + throwable);
            Utilities.check(throwable);
            return false;
        }
    }

    public boolean checkXPass() {
        return this.checkHttpd() && this.checkTomcat();
    }

    public void clearAuthorization() {
        this.authorizationString = null;
    }

    public PantherAssessmentState getAssessmentState() throws Exception {
        URL uRL = null;
        try {
            uRL = new URL(Constants.fillInUrl("http://FOO1/GetAssessmentState.action?SOURCE=FOO2&SESSION_ID=FOO3&ER_ID=FOO4&HOST=FOO5", this.serverHostPortAndTomcatContext, this.myId, this.sessionId, this.erId, this.requestingHost));
        }
        catch (Throwable throwable) {
            throw new XPassUnavailableException("Unable to create URL to retrieve assessment state", throwable);
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("GET");
        this.makeConnection(httpURLConnection, uRL);
        int n = httpURLConnection.getResponseCode();
        skeletonapplet.Utilities.logPrintln("responseCode = " + n);
        if (n != 200) {
            skeletonapplet.Utilities.logPrintln("throw response code error");
            throw new XPassUnavailableException("Received response code " + n + " while retrieving assessment state XML");
        }
        PantherAssessmentState pantherAssessmentState = this.createAssessmentState(httpURLConnection);
        if (pantherAssessmentState == null) {
            throw new XPassUnavailableException("Unable to retrieve assessment state XML");
        }
        skeletonapplet.Utilities.logPrintln(pantherAssessmentState.toString());
        return pantherAssessmentState;
    }

    public String getMediaObjectXml(String string) throws XPassUnavailableException, Exception {
        this.checkStatus();
        Throwable throwable = null;
        for (int i = 1; i <= 5; ++i) {
            try {
                skeletonapplet.Utilities.logPrintln("\n\nBefore innerGetMediaObjectXml()");
                String string2 = this.innerGetMediaObjectXml(string);
                skeletonapplet.Utilities.logPrintln("After innerGetMediaObjectXml()\n\n");
                if (string2 == null) continue;
                return string2;
            }
            catch (Throwable throwable2) {
                ErrorUtils.check(throwable2);
                skeletonapplet.Utilities.logPrintln("Throwable = " + throwable2);
                throwable = throwable2;
            }
        }
        throw new ApplicationError.GetSessionXml("Unable to read media object XML even after 5 attempts.", throwable);
    }

    public String getMode() {
        return this.mode;
    }

    public void initialize(JApplet jApplet, String string) {
        this.applet = jApplet;
        if (string == null) {
            throw new ApplicationError.ParameterProcessing("Assessment server initialization message is null");
        }
        List<String> list = null;
        try {
            list = ObfuscateDecode.decode(string);
        }
        catch (Throwable throwable) {
            Utilities.checkIgnore(throwable);
            throw new ApplicationError.ParameterProcessing("Error breaking down applet key");
        }
        if (list.size() != 9) {
            throw new ApplicationError.ParameterProcessing(Constants.fillIn("Applet key size mismatch: size is FOO1, should be FOO2", list.size(), 13));
        }
        this.serverHostAndPort = list.get(0);
        this.tomcatContext = list.get(1);
        this.useCompression = Boolean.parseBoolean(list.get(2));
        this.useEncryption = Boolean.parseBoolean(list.get(3));
        this.useConnectivityTestEvaluation = Boolean.parseBoolean(list.get(4));
        this.mode = list.get(5);
        this.sessionId = list.get(6);
        this.erId = list.get(7);
        this.requestingHost = list.get(8);
        this.refererString = "http://" + this.serverHostAndPort + "/index.html";
        PacketTracer.useConnectivityTestEvaluation(this.useConnectivityTestEvaluation);
        if (this.serverHostAndPort == null) {
            this.serverHostPortAndTomcatContext = null;
        } else {
            this.serverHostPortAndTomcatContext = this.tomcatContext == null ? this.serverHostAndPort : StringUtils.withoutTrailing(this.serverHostAndPort, '/') + "/" + StringUtils.withoutLeading(this.tomcatContext, '/');
            this.serverHostPortAndTomcatContext = StringUtils.withoutTrailing(this.serverHostPortAndTomcatContext, '/');
        }
        try {
            String string2 = jApplet.getParameter("maxsessionpiecesize");
            this.maximumSessionPieceSize = Integer.parseInt(string2);
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
            this.maximumSessionPieceSize = 50000;
        }
    }

    public boolean isInAutoSave() {
        return this.inAutoSave;
    }

    public boolean isInFinalSave() {
        return this.inFinalSave;
    }

    public boolean isUp() {
        return this.isUp;
    }

    public void putPtsiAutoSaveXml(String string, String string2) throws Throwable {
        this.putPtsiAutoSaveXml(string, string2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPtsiAutoSaveXml(String string, String string2, boolean bl) throws Throwable {
        if (this.isInFinalSave()) {
            return;
        }
        if (this.isInAutoSave()) {
            if (bl) {
                while (this.isInAutoSave()) {
                    ThreadUtils.guaranteedSleep(25L);
                }
            } else {
                return;
            }
        }
        try {
            this.inAutoSave = true;
            this.putSessionXml(string, string2, "Autosave", "http://FOO1/PutAutoSavePieces.action?SOURCE=FOO2&SIZE=FOO3&CHECKSUM=FOO4&GENERATION=FOO5&NUMBER=FOO6&TOTAL=FOO7&TRY=FOO8&ITEM_ID=FOO9&SESSION_ID=FOO10&ER_ID=FOO11&HOST=FOO12");
        }
        finally {
            this.inAutoSave = false;
        }
    }

    public boolean reestablish() {
        if (this.checkXPass()) {
            this.markAsUp();
            return true;
        }
        return false;
    }

    public boolean reestablish(long l, long l2) {
        long l3;
        long l4 = l3 = System.currentTimeMillis();
        while (l4 <= l3 + l) {
            if (this.reestablish()) {
                return true;
            }
            ThreadUtils.guaranteedSleep(l2);
            l4 = System.currentTimeMillis();
        }
        return false;
    }

    public void register() throws Exception {
        URL uRL = new URL(Constants.fillInUrl("http://FOO1/Register.action?SOURCE=FOO2&SESSION_ID=FOO3&ER_ID=FOO4&HOST=FOO5", this.serverHostPortAndTomcatContext, this.myId, this.sessionId, this.erId, this.requestingHost));
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("GET");
        this.makeConnection(httpURLConnection, uRL);
        int n = httpURLConnection.getResponseCode();
        skeletonapplet.Utilities.logPrintln("register responseCode = " + n);
    }

    public void reportGeneralError(URL uRL, String string, Throwable throwable) throws XPassUnavailableException {
        this.reportGeneralError(uRL, string, throwable, null);
    }

    public void reportGeneralError(URL uRL, String string, Throwable throwable, Map<String, String> map) throws XPassUnavailableException {
        this.checkStatus();
        try {
            URL uRL2 = null;
            uRL2 = this.serverHostAndPort == null ? new URL(uRL, "ReportError.action") : new URL(Constants.fillInUrl("http://FOO1/ReportError.action?SOURCE=FOO2&SESSION_ID=FOO3&ER_ID=FOO4&HOST=FOO5", this.serverHostPortAndTomcatContext, this.myId, this.sessionId, this.erId, this.requestingHost));
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL2.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            try {
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(httpURLConnection.getOutputStream()));
                this.addPostParameter(printWriter, "errortype", string);
                if (throwable != null) {
                    this.addAdditionalPostParameter(printWriter, "throwablemessage", throwable.getMessage());
                    this.addAdditionalPostParameter(printWriter, "throwablestacktrace", Utilities.stackTrace(throwable));
                }
                if (map != null) {
                    for (String string2 : map.keySet()) {
                        this.addAdditionalPostParameter(printWriter, string2, map.get(string2));
                    }
                }
                this.addAdditionalPostParameter(printWriter, "javaconsole", Utilities.buffer.toString());
                printWriter.flush();
            }
            catch (IOException iOException) {
                this.markAsDown();
                throw new XPassUnavailableException("Unable to write session XML to assessment servers", iOException);
            }
            this.makeConnection(httpURLConnection, uRL2);
            Utilities.read(httpURLConnection.getInputStream());
            httpURLConnection.getInputStream().close();
        }
        catch (Throwable throwable2) {
            Utilities.checkIgnore(throwable2);
            throw new Error("Unable to continue processing", throwable2);
        }
    }

    public void setAuthorization(String string, String string2) throws Exception {
        Base64Encode base64Encode = new Base64Encode();
        this.authorizationString = "Basic " + Utilities.safeUrlEncode(base64Encode.encodeString(string + ":" + string2));
    }

    protected void addAdditionalPostParameter(PrintWriter printWriter, String string, String string2) {
        printWriter.print("&");
        this.addPostParameter(printWriter, string, string2);
    }

    protected void addAuthorization(HttpURLConnection httpURLConnection) {
        if (this.authorizationString != null) {
            httpURLConnection.setRequestProperty("Authorization", this.authorizationString);
        }
    }

    protected void addPostParameter(PrintWriter printWriter, String string, String string2) {
        printWriter.print(string);
        printWriter.print("=");
        printWriter.print(Utilities.safeUrlEncode(string2));
    }

    protected synchronized int advanceGeneration() {
        ++this.generation;
        skeletonapplet.Utilities.logPrintln("\n\ngeneration = " + this.generation + "\n\n");
        return this.generation;
    }

    protected void checkStatus() throws XPassUnavailableException {
        if (!this.isUp()) {
            if (this.checkXPass()) {
                this.markAsUp();
            } else {
                throw new XPassUnavailableException("Assessment server is still down");
            }
        }
    }

    protected PantherAssessmentState createAssessmentState(HttpURLConnection httpURLConnection) throws Exception {
        PantherAssessmentState pantherAssessmentState = new PantherAssessmentState();
        Node node = null;
        try {
            String string = Utilities.read(httpURLConnection.getInputStream());
            httpURLConnection.getInputStream().close();
            node = XMLUtils.parseToNode("Assessment", string);
        }
        catch (Throwable throwable) {
            ErrorUtils.checkSwallow(throwable);
            pantherAssessmentState.setMessage("Can't parse state XML:  " + throwable.getMessage());
            pantherAssessmentState.setStackTrace(ErrorUtils.stackTrace(throwable));
            pantherAssessmentState.setErrorType("unparseablexml");
            return pantherAssessmentState;
        }
        pantherAssessmentState.fromXml(node);
        return pantherAssessmentState;
    }

    protected String innerGetMediaObjectXml(String string) throws Exception {
        URL uRL = new URL(Constants.fillInUrl("http://FOO1/GetMediaObjectSession.action?MEDIA_OBJECT_ID=FOO2&SOURCE=FOO3&SESSION_ID=FOO4&ER_ID=FOO5&HOST=FOO6", this.serverHostPortAndTomcatContext, string, this.myId, this.sessionId, this.erId, this.requestingHost));
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("GET");
        this.makeConnection(httpURLConnection, uRL);
        return XPassUtils.readSessionInfo(httpURLConnection.getContentType(), httpURLConnection.getInputStream(), this.useCompression, this.useEncryption);
    }

    protected void makeConnection(HttpURLConnection httpURLConnection, URL uRL) throws XPassUnavailableException {
        try {
            this.addAuthorization(httpURLConnection);
            httpURLConnection.connect();
            this.markAsUp();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            skeletonapplet.Utilities.logPrintln("e = " + socketTimeoutException);
            this.markAsDown();
            throw new XPassUnavailableException("Socket timed out during request to " + uRL, socketTimeoutException);
        }
        catch (IOException iOException) {
            skeletonapplet.Utilities.logPrintln("e = " + iOException);
            this.markAsDown();
            throw new XPassUnavailableException("IO Exception during request to " + uRL, iOException);
        }
    }

    protected void markAsDown() {
        this.isUp = false;
        this.lastUnsuccessfulAccess = System.currentTimeMillis();
    }

    protected void markAsUp() {
        this.isUp = true;
        this.lastSuccessfulAccess = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean putSessionDataChunk(String string, byte[] byArray, byte[] byArray2, String string2, int n, int n2, int n3, int n4) throws Throwable {
        if (n < this.generation) {
            throw new ApplicationError.SaveGeneration("myGeneration = " + n + ", but current generation is " + this.generation);
        }
        int n5 = byArray2.length;
        long l = Utilities.calculateCheckSum(byArray2);
        HttpURLConnection httpURLConnection = null;
        boolean bl = false;
        try {
            URL uRL = new URL(Constants.fillInUrl(string2, this.serverHostPortAndTomcatContext, this.myId, n5, l, n, n2, n3, n4, string, this.sessionId, this.erId, this.requestingHost));
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.addRequestProperty("content-type", MimeContent.getContentType(byArray));
            this.addAuthorization(httpURLConnection);
            httpURLConnection.setDoOutput(true);
            XPassUtils.writeSessionInfo(byArray, byArray2, httpURLConnection.getOutputStream());
            httpURLConnection.getOutputStream().flush();
            this.makeConnection(httpURLConnection, uRL);
            int n6 = httpURLConnection.getResponseCode();
            PantherAssessmentState pantherAssessmentState = this.createAssessmentState(httpURLConnection);
            this.verifyAssessmentState(pantherAssessmentState);
            bl = n6 == 200 && pantherAssessmentState != null && pantherAssessmentState.isUploadSuccessful();
        }
        catch (IOException iOException) {
            this.markAsDown();
            throw new XPassUnavailableException("Unable to write session XML to XPass", iOException);
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
            if (throwable instanceof ApplicationError.AppletOvertaken || throwable instanceof ApplicationError.AssessmentComplete || throwable instanceof ApplicationError.SaveGeneration) {
                throw throwable;
            }
        }
        finally {
            if (httpURLConnection != null) {
                try {
                    httpURLConnection.disconnect();
                }
                catch (Throwable throwable) {
                    Utilities.check(throwable);
                }
                try {
                    if (httpURLConnection.getOutputStream() != null) {
                        httpURLConnection.getOutputStream().close();
                    }
                }
                catch (Throwable throwable) {
                    Utilities.check(throwable);
                }
                try {
                    if (httpURLConnection.getInputStream() != null) {
                        httpURLConnection.getInputStream().close();
                    }
                }
                catch (Throwable throwable) {
                    Utilities.check(throwable);
                }
            }
        }
        return bl;
    }

    protected boolean putSessionPiece(String string, byte[] byArray, byte[] byArray2, String string2, int n, int n2, int n3) throws Throwable {
        if (n < this.generation) {
            throw new ApplicationError.SaveGeneration("myGeneration = " + n + ", but current generation is " + this.generation);
        }
        Throwable throwable = null;
        for (int i = 1; i <= 5; ++i) {
            try {
                if (!this.putSessionDataChunk(string, byArray, byArray2, string2, n, n2, n3, i)) continue;
                return true;
            }
            catch (Throwable throwable2) {
                ErrorUtils.check(throwable2);
                if (throwable2 instanceof ApplicationError.AppletOvertaken || throwable2 instanceof ApplicationError.AssessmentComplete || throwable2 instanceof ApplicationError.SaveGeneration) {
                    throw throwable2;
                }
                throwable = throwable2;
            }
        }
        throw new XPassUnavailableException("Unable to write a session XML piece even after 5 attempts.", throwable);
    }

    protected void putSessionPiecesXml(String string, String string2, String string3, int n) throws Throwable {
        this.checkStatus();
        if (n < this.generation) {
            throw new ApplicationError.SaveGeneration("myGeneration = " + n + ", but current generation is " + this.generation);
        }
        byte[] byArray = MimeContent.generateSeparator();
        byte[] byArray2 = XPassUtils.convertStringToDataBytes(string2, this.useCompression, this.useEncryption);
        int n2 = byArray2.length / this.maximumSessionPieceSize;
        if (byArray2.length % this.maximumSessionPieceSize > 0) {
            ++n2;
        }
        int n3 = 1;
        int n4 = 0;
        int n5 = Math.min(this.maximumSessionPieceSize, byArray2.length - n4);
        while (n4 < byArray2.length && n5 > 0) {
            byte[] byArray3 = new byte[n5];
            for (int i = 0; i < n5; ++i) {
                byArray3[i] = byArray2[n4 + i];
            }
            this.putSessionPiece(string, byArray, byArray3, string3, n, n3, n2);
            ++n3;
            n5 = Math.min(this.maximumSessionPieceSize, byArray2.length - (n4 += n5));
        }
    }

    protected void putSessionXml(String string, String string2, String string3, String string4) throws Throwable {
        this.checkStatus();
        int n = this.advanceGeneration();
        skeletonapplet.Utilities.logPrintln("\n\nmyGeneration = " + n + "\n\n");
        this.putSessionPiecesXml(string, string2, string4, n);
    }

    protected void verifyAssessmentState(PantherAssessmentState pantherAssessmentState) {
        if (pantherAssessmentState != null && pantherAssessmentState.isError()) {
            String string = pantherAssessmentState.getErrorType();
            if (string.equals("appletovertaken")) {
                throw new ApplicationError.AppletOvertaken();
            }
            if (string.equals("assessmentcomplete")) {
                throw new ApplicationError.AssessmentComplete();
            }
            if (string.equals("unparseablexml")) {
                throw new Error("Couldn't parse assessment state XML");
            }
        }
    }
}

